import networkx as nx
import csv


def main():

    # 無向グラフの生成（ここを入れ替えればどんなグラフでもOK）
    number_of_nodes = 1000
    number_of_edges_to_attach = 3
    g = nx.generators.random_graphs.barabasi_albert_graph(number_of_nodes, number_of_edges_to_attach)

    # エッジリストの書き出し
    with open("edges.csv", "w", encoding="utf8") as f:
        writer = csv.writer(f, lineterminator="\n")
        writer.writerow(["population", number_of_nodes])
        for node in g.nodes():
            edges = g.edges(node)
            for edge in edges:
                writer.writerow(edge)

    # ノードの生成
    all_nodes = []
    for i, node in enumerate(g.nodes):
        n = Node(i)
        all_nodes.append(n)
        edges = g.edges(node)
        n.num_connection = len(edges)

    # ノードに繋がりを定義
    for node in g.nodes():
        edges = g.edges(node)
        for edge in edges:
            from_node = all_nodes[edge[0]]
            to_node = all_nodes[edge[1]]
            from_node.connection.append(to_node)

    # ならべかえ
    sorted_nodes = sorted(all_nodes, key=lambda u: u.num_connection, reverse=True)

    # つながりの多いノードランキング
    with open("node_rank.csv", "w") as f:
        writer = csv.writer(f, lineterminator="\n")
        writer.writerow(["id", "num_connection"])
        for n in sorted_nodes:
            writer.writerow([n.id, n.num_connection])


class Node(object):

    def __init__(self, id_):
        self.id = id_
        self.num_connection = 0
        self.connection = []

    def __repr__(self):
        return str(self.id)


if __name__ == "__main__":
    main()
